/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4094;
import net.minecraft.class_4140;
import net.minecraft.class_4151;
import net.minecraft.class_4836;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5819;

public abstract class AbstractMobContainerItem
extends class_1747 {
    private final float mobContainerHeight;
    private final float mobContainerWidth;
    private final boolean isAquarium;

    protected AbstractMobContainerItem(class_2248 block, class_1792.class_1793 properties, float width, float height, boolean aquarium) {
        super(block, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
        this.isAquarium = aquarium;
    }

    public boolean isAquarium() {
        return this.isAquarium;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(class_1297 e) {
        float margin = 0.125f;
        float h = e.method_17682() - margin;
        float w = e.method_17681() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(class_1657 player) {
    }

    public void playFailSound(class_1657 player) {
    }

    public void playReleaseSound(class_1937 world, class_243 v) {
    }

    public boolean isFull(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("BlockEntityTag");
    }

    private <T extends class_1297> boolean canCatch(T entity, class_1657 player) {
        String name;
        if (!entity.method_5805() || ForgeHelper.isMultipartEntity(entity) || entity instanceof class_1657) {
            return false;
        }
        if (entity instanceof class_1309) {
            class_1321 pet;
            class_1309 living = (class_1309)entity;
            if (living.method_29504()) {
                return false;
            }
            if (entity instanceof class_1321 && (pet = (class_1321)entity).method_6181() && !pet.method_6171((class_1309)player)) {
                return false;
            }
            int p = CommonConfigs.Functional.CAGE_HEALTH_THRESHOLD.get();
            if (p != 100 && living.method_6032() > living.method_6063() * ((float)p / 100.0f)) {
                return false;
            }
        }
        if ((name = Utils.getID((class_1299)entity.method_5864()).toString()).contains("alexsmobs") && name.contains("centipede")) {
            return false;
        }
        if (CommonConfigs.Functional.CAGE_ALL_MOBS.get().booleanValue() || CapturedMobHandler.isCommandMob(name)) {
            return true;
        }
        ICatchableMob cap = CapturedMobHandler.getCatchableMobCapOrDefault(entity);
        return cap.canBeCaughtWithItem(entity, (class_1792)this, player);
    }

    public abstract boolean canItemCatch(class_1297 var1);

    public class_1799 saveEntityInItem(class_1297 entity, class_1799 currentStack, class_1799 bucketStack) {
        class_2487 cmp;
        class_1799 returnStack = new class_1799((class_1935)this);
        if (currentStack.method_7938()) {
            returnStack.method_7977(currentStack.method_7964());
        }
        if ((cmp = MobContainer.createMobHolderItemTag(entity, this.getMobContainerWidth(), this.getMobContainerHeight(), bucketStack, this.isAquarium)) != null) {
            returnStack.method_7959("BlockEntityTag", (class_2520)cmp);
        }
        return returnStack;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_2487 com = stack.method_7941("BlockEntityTag");
        class_1657 player = context.method_8036();
        if (!context.method_8036().method_5715() && com != null) {
            class_2487 nbt;
            class_1297 entity;
            boolean success = false;
            class_1937 world = context.method_8045();
            class_243 v = context.method_17698();
            if (com.method_10545("BucketHolder")) {
                class_1799 bucketStack = class_1799.method_7915((class_2487)com.method_10562("BucketHolder").method_10562("Bucket"));
                class_1792 class_17922 = bucketStack.method_7909();
                if (class_17922 instanceof class_1755) {
                    class_1755 bi = (class_1755)class_17922;
                    bi.method_7728(player, world, bucketStack, context.method_8037());
                    success = true;
                }
            } else if (com.method_10545("MobHolder") && (entity = class_1299.method_17842((class_2487)(nbt = com.method_10562("MobHolder")).method_10562("EntityData"), (class_1937)world, o -> o)) != null) {
                success = true;
                if (!world.field_9236) {
                    if (!player.method_7337() && entity instanceof class_5354) {
                        class_5354 ang = (class_5354)entity;
                        ang.method_29921();
                        ang.method_29513(player.method_5667());
                        ang.method_6015((class_1309)player);
                    }
                    entity.method_5641(v.method_10216(), v.method_10214(), v.method_10215(), context.method_8044(), 0.0f);
                    if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof class_1308) {
                        class_1308 mob = (class_1308)entity;
                        mob.method_5971();
                    }
                    UUID temp = entity.method_5667();
                    if (nbt.method_10545("UUID")) {
                        UUID id = nbt.method_25926("UUID");
                        entity.method_5826(id);
                    }
                    if (!world.method_8649(entity)) {
                        entity.method_5826(temp);
                        success = world.method_8649(entity);
                        if (!success) {
                            Supplementaries.LOGGER.warn("Failed to release caged mob");
                        }
                    }
                }
                if (player.method_7337() && nbt.method_10545("UUID")) {
                    nbt.method_25927("UUID", class_3532.method_15378((class_5819)world.field_9229));
                }
            }
            if (success) {
                if (!world.field_9236) {
                    this.playReleaseSound(world, v);
                    if (!player.method_7337()) {
                        class_1799 returnItem = new class_1799((class_1935)this);
                        if (stack.method_7938()) {
                            returnItem.method_7977(stack.method_7964());
                        }
                        Utils.swapItemNBT((class_1657)player, (class_1268)context.method_20287(), (class_1799)stack, (class_1799)returnItem);
                    }
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        return super.method_7884(context);
    }

    public boolean blocksPlacement() {
        return true;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag != null) {
            class_2487 com = tag.method_10562("MobHolder");
            if (com.method_33133()) {
                com = tag.method_10562("BucketHolder");
            }
            if (com.method_10545("Name")) {
                tooltip.add((class_2561)class_2561.method_43471((String)com.method_10558("Name")).method_27692(class_124.field_1080));
            }
        }
        if (ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue()) {
            this.addPlacementTooltip(tooltip);
        }
    }

    public void addPlacementTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43471((String)"message.supplementaries.cage").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
    }

    private void angerNearbyEntities(class_1297 entity, class_1657 player) {
        if (entity instanceof class_5354 && entity instanceof class_1308) {
            AbstractMobContainerItem.getEntitiesInRange((class_1308)entity).stream().filter(mob -> mob != entity).map(class_5354.class::cast).forEach(mob -> {
                mob.method_29921();
                mob.method_29513(player.method_5667());
                mob.method_6015((class_1309)player);
            });
        }
        if (entity instanceof class_4836) {
            entity.method_5643(class_1282.method_5532((class_1657)player), 0.0f);
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            class_1937 class_19372 = player.field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                Optional optional = villager.method_18868().method_18904(class_4140.field_18442);
                optional.ifPresent(entities -> entities.method_38978(class_4094.class::isInstance).forEach(e -> serverLevel.method_19496(class_4151.field_18476, (class_1297)player, (class_4094)e)));
            }
        }
    }

    private static List<?> getEntitiesInRange(class_1308 e) {
        double d0 = e.method_26825(class_5134.field_23717);
        class_238 aabb = class_238.method_29968((class_243)e.method_19538()).method_1009(d0, 10.0, d0);
        return e.field_6002.method_8390(e.getClass(), aabb, class_1301.field_6155);
    }

    public class_1269 doInteract(class_1799 stack, class_1657 player, class_1297 entity, class_1268 hand) {
        if (hand == null) {
            return class_1269.field_5811;
        }
        if (this.canCatch(entity, player)) {
            class_1308 mob;
            class_1799 bucket = class_1799.field_8037;
            if (this.isAquarium) {
                bucket = BucketHelper.getBucketFromEntity(entity);
            }
            BucketHelper.associateMobToBucketIfAbsent(entity.method_5864(), bucket.method_7909());
            ForgeHelper.reviveEntity((class_1297)entity);
            if (player.field_6002.field_9236) {
                return class_1269.field_5812;
            }
            this.playCatchSound(player);
            this.angerNearbyEntities(entity, player);
            if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof class_1308) {
                mob = (class_1308)entity;
                mob.method_5971();
            }
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                mob.method_5932(true, !player.method_31549().field_7477);
            }
            Utils.swapItemNBT((class_1657)player, (class_1268)hand, (class_1799)stack, (class_1799)this.saveEntityInItem(entity, stack, bucket));
            entity.method_5650(class_1297.class_5529.field_26999);
            return class_1269.field_21466;
        }
        if (player.method_37908().field_9236 && entity instanceof class_1309) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.supplementaries.cage.fail"), true);
        }
        this.playFailSound(player);
        return class_1269.field_5811;
    }

    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        if (player != null && !player.method_5715() && this.blocksPlacement()) {
            return class_1269.field_5811;
        }
        return super.method_7712(context);
    }
}

